<?php
	global $post;
	$userid = campress_lecturer_get_meta('userid');
	$email = get_the_author_meta('email', $userid );
	$mobile = campress_lecturer_get_meta('mobile');
	$skype = campress_lecturer_get_meta('skype');
	$website = campress_lecturer_get_meta('website');
	$address = campress_lecturer_get_meta('address');

	$facebook = campress_lecturer_get_meta('facebook');
	$twitter = campress_lecturer_get_meta('twitter');
	$google = campress_lecturer_get_meta('google');
	$linkedin = campress_lecturer_get_meta('linkedin');
	$instagram = campress_lecturer_get_meta('instagram');
	$youtube = campress_lecturer_get_meta('youtube');
	$job = campress_lecturer_get_meta('job');
?>
<article <?php post_class('detail-lecturer'); ?>>
	<div class="row">
		<div class="col-md-3">
			<div class="widget">
				<ul class="list-info">
					<?php if ($email) { ?>
						<li><i class="mn-icon-220"></i> <?php echo trim($email); ?></li>
					<?php } ?>
					<?php if ($mobile) { ?>
						<li><i class="mn-icon-258"></i> <?php echo trim($mobile); ?></li>
					<?php } ?>
					<?php if ($skype) { ?>
						<li><i class="mn-icon-1422"></i> <?php echo trim($skype); ?></li>
					<?php } ?>
					<?php if ($website) { ?>
						<li><i class="mn-icon-813"></i> <?php echo trim($website); ?></li>
					<?php } ?>
					<?php if ($address) { ?>
						<li><i class="mn-icon-1142"></i> <?php echo trim($address); ?></li>
					<?php } ?>
				</ul>
			</div>
		</div>
		<div class="col-md-9">
			<div class="header-info">
				<div class="row">
					<div class="col-md-4">
						<?php
				            $thumb = campress_post_thumbnail();
				            echo trim($thumb);
				        ?>
					</div>
					<div class="col-md-8">
						<div class="infor">
							<h3 class="name">
								<a href="<?php the_permalink(); ?>">
									<?php the_title(); ?>
								</a>
							</h3>
							<?php if ( $job ): ?>
								<div class="job"><?php echo trim($job); ?></div>
							<?php endif; ?>
							<div class="description">
								<?php the_excerpt(); ?>
							</div>
						</div>
						<div class="course-info">
							<?php
								$loop = new WP_Query( array( 'author' =>  $userid, 'posts_per_page' => -1, 'post_type' => EDR_PT_COURSE ) );
								$total = $loop->post_count;
							?>
							<div class="course-nb"><?php echo sprintf(_n('%d <span>Course</span>', '%d <span>Courses</span>', $total, 'campress'), $total); ?></div>
							<?php
								$total_rating = 0;
								$rating_count = 0;
								while ( $loop->have_posts() ): $loop->the_post();
									$rating = campress_get_total_rating( get_the_ID() );
									if ($rating > 0) {
										$total_rating += $rating;
										$rating_count++;
									}
									
								endwhile;
								wp_reset_postdata();
								$total_rating = $total_rating/$rating_count;
							?>
							<div class="course-rating"><?php echo sprintf(__('%s <span>Rating</span>', 'campress'), $total_rating); ?></div>
						</div>
						<div class="socials">
							<?php if ( $facebook ): ?>
								<a href="<?php echo esc_url($facebook); ?>" class="facebook"><i class="mn-icon-1405"></i></a>
							<?php endif; ?>
							<?php if ( $twitter ): ?>
								<a href="<?php echo esc_url($twitter); ?>" class="twitter"><i class="mn-icon-1406"></i></a>
							<?php endif; ?>
							<?php if ( $google ): ?>
								<a href="<?php echo esc_url($google); ?>" class="google"><i class="mn-icon-1409"></i></a>
							<?php endif; ?>
							<?php if ( $linkedin ): ?>
								<a href="<?php echo esc_url($linkedin); ?>" class="linkedin"><i class="mn-icon-1408"></i></a>
							<?php endif; ?>
							<?php if ( $instagram ): ?>
								<a href="<?php echo esc_url($instagram); ?>" class="instagram"><i class="mn-icon-1416"></i></a>
							<?php endif; ?>
							<?php if ( $youtube ): ?>
								<a href="<?php echo esc_url($youtube); ?>" class="youtube"><i class="mn-icon-1407"></i></a>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>

			<div class="tabs-info">
				<div class="panel-affix-wrapper">
		            <div class="apus-tabs panel-affix">
		                <ul class="nav nav-tabs">
							<li><a href="#course-description"><?php esc_html_e( 'Desciptions', 'campress' ); ?></a></li>
							<li><a href="#course-courses"><?php echo sprintf(_n('Total Course', 'Total Courses', $total, 'campress'), $total); ?></a></li>
						</ul>
		            </div>
		        </div>
		        <div id="course-description" class="entry-description">
		        	<h3 class="title"><?php echo esc_html_e('Personal Summary','campress') ?></h3>
		        	<?php the_content(); ?>
		        </div>

		        <div id="course-courses" class="entry-courses">
		        	<h3 class="title"><?php echo esc_html_e('Taught Courses','campress') ?></h3>
		        	<div class="owl-carousel" data-items="3" data-carousel="owl" data-smallmedium="2" data-extrasmall="1" data-pagination="false" data-nav="true">
						<?php
						while ( $loop->have_posts() ): $loop->the_post();
							?>
							<div class="item">
								<?php Edr_View::template_part( 'content', 'course' ); ?>
							</div>
							<?php
						// End the loop.
						endwhile;
						wp_reset_postdata();
						?>
					</div>
		        </div>

			</div>
		</div>
	</div>
</article>