<?php
$course_id = get_the_ID();
$duration = campress_educator_get_meta('duration');
$registered = campress_educator_get_students_by_course( $course_id );
$certificate = campress_educator_get_meta('certificate');
$langauge = campress_educator_get_meta('langauge');
$prerequisites = get_post_meta( $course_id, '_edr_prerequisites', true );
$difficulty = get_post_meta( $course_id, '_edr_difficulty', true );
$capacity = campress_educator_get_meta('capacity');
$startcourse = campress_educator_get_meta('startcourse');
$location = campress_educator_get_meta('location');
$levels = edr_get_difficulty_levels();

$obj = Edr_Courses::get_instance();
$lesson = $obj->get_course_lessons($course_id);
$nb_lesson = is_array($lesson) ? count($lesson) : 0;
?>
<h3 class="feature-title"><?php echo esc_html__('Course Features','campress'); ?></h3>
<div class="row">
	<div class="col-md-4">
		<ul>
			<li>
				<i class="mn-icon-1104"></i>
				<?php esc_html_e( 'Course Duration:', 'campress' ); ?>
				<span><?php echo trim($duration); ?></span>
			</li>
			<li>
				<i class="mn-icon-1053"></i>
				<?php esc_html_e( 'Category:', 'campress' ); ?>
				<span><?php echo trim( edr_get_course_categories_html($course_id) ); ?></span>
			</li>
			<li>
				<i class="mn-icon-393"></i>
				<?php esc_html_e( 'Students:', 'campress' ); ?>
				<span><?php echo count( $registered ); ?></span>
			</li>
			<li>
				<i class="mn-icon-1240"></i>
				<?php esc_html_e( 'Certificate:', 'campress' ); ?>
				<span><?php echo ($certificate ? esc_html__('Yes', 'campress') : esc_html__('No', 'campress') ); ?></span>
			</li>
		</ul>
	</div>
	<div class="col-md-4">
		<ul>
			<li>
				<i class="mn-icon-1138"></i>
				<?php esc_html_e( 'Location:', 'campress' ); ?>
				<span><?php echo trim($location); ?></span>
			</li>
			<li>
				<i class="mn-icon-560"></i>
				<?php esc_html_e( 'Language:', 'campress' ); ?>
				<span><?php echo trim( $langauge ); ?></span>
			</li>
			<li>
				<i class="mn-icon-621"></i>
				<?php esc_html_e( 'Lesson:', 'campress' ); ?>
				<span><?php echo trim( $nb_lesson ); ?></span>
			</li>
			<li>
				<i class="mn-icon-41"></i>
				<?php esc_html_e( 'Viewers:', 'campress' ); ?>
				<span><?php echo (int)campress_get_course_views(); ?></span>
			</li>
		</ul>
	</div>
	<div class="col-md-4">
		<ul>
			<li>
				<i class="mn-icon-1104"></i>
				<?php esc_html_e( 'Prerequisites:', 'campress' ); ?>
				<span><?php echo ($prerequisites ? esc_html__('Yes', 'campress') : esc_html__('No', 'campress') ); ?></span>
			</li>
			<li>
				<i class="mn-icon-1013"></i>
				<?php esc_html_e( 'Skill Level:', 'campress' ); ?>
				<span><?php echo trim( isset($levels[$difficulty]) ? $levels[$difficulty] : '' ); ?></span>
			</li>
			<li>
				<i class="mn-icon-613"></i>
				<?php esc_html_e( 'Course Capacity:', 'campress' ); ?>
				<span><?php echo trim( $capacity ); ?></span>
			</li>
			<li>
				<i class="mn-icon-1128"></i>
				<?php esc_html_e( 'Start Course:', 'campress' ); ?>
				<span><?php echo trim($startcourse); ?></span>
			</li>
		</ul>
	</div>
</div>