<?php

if ( !function_exists( 'campress_event_metaboxes' ) ) {
	function campress_event_metaboxes(array $metaboxes) {
        $roles = array( 'administrator', 'lecturer', 'author' );
        $users = get_users( array( 'role__in' => $roles ) );
        $authors = array();
        if ( $users ) {
            foreach ($users as $user) {
                $authors[$user->ID] = $user->data->display_name;
            }
        }
		$prefix = 'apus_event_';
        // Featured
        $fields = array(
            array(
                'id' => $prefix.'featured',
                'type' => 'checkbox',
                'name' => esc_html__('Featured Event', 'campress')
            )
        );
        
        $metaboxes[$prefix . 'event_setting'] = array(
            'id'                        => $prefix . 'event_setting',
            'title'                     => esc_html__( 'Event Settings', 'campress' ),
            'object_types'              => array( 'tribe_events' ),
            'context'                   => 'normal',
            'priority'                  => 'high',
            'show_names'                => true,
            'fields'                    => $fields
        );
        // speaker description
	    $fields = array(
            array(
                'id' => $prefix.'speaker_desc',
                'type' => 'textarea',
                'name' => esc_html__('Speaker Descriprtion', 'campress')
            ),
            array(
                'id' => $prefix.'speakers',
                'type' => 'multicheck',
                'name' => esc_html__('Speakers', 'campress'),
                'description' => esc_html__('Choose user from "Author" role.', 'campress'),
                'options' => $authors
            )
    	);
		
	    $metaboxes[$prefix . 'speakers_setting'] = array(
			'id'                        => $prefix . 'speakers_setting',
			'title'                     => esc_html__( 'Speakers Settings', 'campress' ),
			'object_types'              => array( 'tribe_events' ),
			'context'                   => 'normal',
			'priority'                  => 'high',
			'show_names'                => true,
			'fields'                    => $fields
		);
        
	    return $metaboxes;
	}
}
add_filter( 'cmb2_meta_boxes', 'campress_event_metaboxes' );

if ( !function_exists( 'campress_cmb2_style' ) ) {
	function campress_cmb2_style() {
		wp_enqueue_style( 'campress-cmb2-style', get_template_directory_uri() . '/inc/vendors/cmb2/assets/style.css', array(), '1.0' );
	}
}
add_action( 'admin_enqueue_scripts', 'campress_cmb2_style' );


