<?php

$atts  = array_merge( array(
	'layout_type' => 'layout1',
), $atts );

extract( $atts );

$levels = edr_get_difficulty_levels();

$args = array(
    'type' => 'post',
    'child_of' => 0,
    'orderby' => 'name',
    'order' => 'ASC',
    'hide_empty' => true,
    'hierarchical' => 1,
    'taxonomy' => 'edr_course_category'
);
$categories = array( '' => esc_html__('All Categories', 'campress') );
$terms = get_categories( $args );
if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
	foreach ( $terms as $term ) {
 		$categories[$term->slug] =  $term->name;  
	}
}
$instructors = campress_educator_get_lecturers();
?>
<div class="widget widget-search-form <?php echo esc_attr($layout_type); ?>">
	<form action="<?php echo esc_url( home_url( '/' ) ); ?>" method="get">
		<?php if ($layout_type == 'layout1') { ?>
			<div class="layout1">
			<div class="row">
				<div class="col-md-3 col-sm-3">
					<!-- level -->
					<select name="_difficulty">
						<option value=""><?php esc_html_e( 'All Levels', 'campress' ); ?></option>
		               	<?php foreach ($levels as $key => $value) { ?>
	                        <option value="<?php echo trim($key); ?>"><?php echo trim($value); ?></option>
	                    <?php } ?>
	                </select>
				</div>
				<div class="col-md-3 col-sm-3">
					<!-- categories -->
					<select name="_category">
		               	<?php foreach ($categories as $key => $value) { ?>
	                        <option value="<?php echo trim($key); ?>"><?php echo trim($value); ?></option>
	                    <?php } ?>
	                </select>
				</div>
				<div class="col-md-3 col-sm-3">
					<!-- lecturer -->
					<select name="_lecturer">
						<option value=""><?php esc_html_e( 'All Instructors', 'campress' ); ?></option>
		               	<?php foreach ($instructors as $key => $value) { ?>
	                        <option value="<?php echo trim($value->ID); ?>"><?php echo get_the_author_meta('display_name', $value->ID ); ?></option>
	                    <?php } ?>
	                </select>
				</div>
				<div class="col-md-3 col-sm-3">
					<!-- keyword -->
					<input class="input_search" name="s" value="" placeholder="<?php esc_html_e('Enter Keyword', 'campress'); ?>"/>
				</div>
			</div>
			<input type="hidden" name="post_type" value="<?php echo defined('EDR_PT_COURSE') ? EDR_PT_COURSE : ''; ?>" class="post_type" />
			<div class="text-center submit">
				<button type="submit" class="btn btn-theme"><?php esc_html_e( 'Search Courses', 'campress'); ?></button>
			</div>
			</div>
		<?php } else { ?>
			<div class="search-input">
				<div class="row">
					<div class="col-md-3 col-sm-3">
						<!-- level -->
						<select name="_difficulty">
			               	<?php foreach ($levels as $key => $value) { ?>
		                        <option value="<?php echo trim($key); ?>"><?php echo trim($value); ?></option>
		                    <?php } ?>
		                </select>
					</div>
					<div class="col-md-3 col-sm-3">
						<!-- categories -->
						<select name="_category">
			               	<?php foreach ($categories as $key => $value) { ?>
		                        <option value="<?php echo trim($key); ?>"><?php echo trim($value); ?></option>
		                    <?php } ?>
		                </select>
					</div>
					<div class="col-md-3 col-sm-3">
						<!-- keyword -->
						<input class="input_search" name="s" value="" placeholder="<?php esc_html_e('Enter Keyword', 'campress'); ?>"/>
					</div>
					<div class="col-md-3 col-sm-3">
						<div class="search-button">
							<button type="submit" class="btn btn-theme-second"><?php esc_html_e( 'Search Courses', 'campress'); ?></button>
						</div>
					</div>
				</div>
				<input type="hidden" name="post_type" value="<?php echo defined('EDR_PT_COURSE') ? EDR_PT_COURSE : ''; ?>" class="post_type" />
			</div>

		<?php } ?>
	</form>
</div>