<?php
/**
 * List View Single Event
 * This file contains one event in the list view
 *
 * Override this template in your own theme by creating a file at [your-theme]/tribe-events/list/single-event.php
 *
 * @package TribeEventsCalendar
 *
 */
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

global $post;

// Setup an array of venue details for use later in the template
$venue_details = tribe_get_venue_details();

// Venue
$has_venue_address = ( ! empty( $venue_details['address'] ) ) ? ' location' : '';
// Organizer
$organizer = tribe_get_organizer();
$venue_id = tribe_get_venue_id( get_the_ID() );
?>
<div class="tribe-events-list event-list1 ">
      <!-- Event date -->
      
      <div class="left-image">
        <?php echo tribe_event_featured_image( null, 'full' ) ?>
      </div>
      <div class="tribe-events-inner">
        <!-- Event Title -->
        <div class="tribe-events-title-wrapper">
          <?php do_action( 'tribe_events_before_the_event_title' ) ?>
          <h2 class="tribe-events-list-event-title">
            <a class="tribe-event-url" href="<?php echo esc_url( tribe_get_event_link() ); ?>" title="<?php the_title_attribute() ?>" rel="bookmark">
              <?php the_title() ?>
            </a>
          </h2>
          <?php do_action( 'tribe_events_after_the_event_title' ) ?>
        </div>

        <div class="entry-meta-wrapper">
          <div class="entry-meta-time">
            <span class="title-label"><?php echo esc_html__('Start Time:', 'campress'); ?></span> <?php echo trim(campress_tribe_events_event_schedule_start()); ?>
          </div>
      		<div class="entry-meta-time">
            <span class="title-label"><?php echo esc_html__('Finish Time:', 'campress'); ?></span> <?php echo trim(campress_tribe_events_event_schedule_finish()); ?>
          </div>
          <?php if ( tribe_get_address( $venue_id ) ) : ?>
            <!-- Venue Display Info -->
            <div class="tribe-events-venue-details">
              <i class="mn-icon-1142"></i><?php echo tribe_get_address( $venue_id ); ?>
            </div> <!-- .tribe-events-venue-details -->
          <?php endif; ?>
        </div>
      </div>
</div>